library(ggplot2)
library(gridExtra)

# To use for fills, add
ls=0.8
pastelle <-c("#CC6666", "#9999CC", "#66CC99")
blackyellowgreen <- c("#000000", "#E69F00", "#009E73")
grayyellowgreen <- c("#999999", "#E69F00", "#009E73")
brewer1 <-c("#7fc97f","#beaed4","#fdc086")
brewer2 <-c("#666666","#a6761d","#66a61e")
final2 <- c("green", "yellow", "grey")
greyscale<-c("#969696","#636363","#252525")
greenscale<-c("#74c476","#31a354","#006d2c")

fuckit<-c("#e41a1c","#377eb8","#4daf4a")
cbbPalette <- fuckit

hr<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/rpm/hot-rpm.txt",header=T)
cr<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/rpm/cold-rpm.txt",header=T)
hr$replicate<-as.factor(hr$replicate)
cr$replicate<-as.factor(cr$replicate)


hs<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/speed/hot-speed.txt",header=T)
cs<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/speed/cold-speed.txt",header=T)
hs$replicate<-as.factor(hs$replicate)
cs$replicate<-as.factor(cs$replicate)




theme_set(theme_bw())

maxrpm=max(hr$rpm)
minspeed=min(c(min(hs$u),min(cs$u)))
maxspeed=max(c(max(hs$u),max(cs$u)))

##### RPM

ghr<-ggplot(hr,aes(x=generations,y=rpm,color=replicate))+geom_line(size=ls)+geom_point()+ylim(0,maxrpm) + 
  theme(legend.position=c(0.85,0.4),axis.title.x=element_blank(),axis.text.x=element_blank()) + annotate("text", x = 2, y = 3800, label = "hot",size=8,color="black")+
  scale_colour_manual(values=cbbPalette)

# gtr<-ggplot(tr,aes(x=generations,y=rpm,color=replicate))+geom_line(size=ls)+geom_point()+ylim(0,maxrpm) + 
#  theme(legend.position="none",axis.title.y=element_blank(),axis.text.y=element_blank(),axis.title.x=element_blank(),axis.text.x=element_blank())+
#  scale_x_continuous(breaks=c(0,10,20)) + annotate("text", x = 4, y = 3800, label = "hot",size=8,color="red")+ scale_colour_manual(values=cbbPalette)

gcr<-ggplot(cr,aes(x=generations,y=rpm,color=replicate))+geom_line(size=ls)+geom_point()+ylim(0,maxrpm) +
  theme(legend.position="none",axis.title.y=element_blank(),axis.text.y=element_blank(),axis.title.x=element_blank(),axis.text.x=element_blank())+ annotate("text", x = 4, y = 3800, label = "cold",color="black",size=8)+
  scale_colour_manual(values=cbbPalette)





grid.arrange(ghr,gcr,ncol=2,nrow=1,widths=c(3,2),heights=c(1))

dev.copy2eps(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/graph/main-graph-rpm.eps")
